/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWPrincipal;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class VWLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private VWSession session = null;
    private String username = null;
    private VWPrincipal principal;
    protected static Logger logger = Logger.getLogger("filenet.vw.LoginModule");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        logger.entering("VWLoginModule", "initialize");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        logger.exiting("VWLoginModule", "initialize");
    }

    public boolean login() throws LoginException {
        logger.entering("VWLoginModule", "login");
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        String password = null;
        this.username = (String)this.sharedState.get("javax.security.auth.login.name");
        password = (String)this.sharedState.get("javax.security.auth.login.password");
        if (this.username == null || password == null) {
            Callback[] callbacks = null;
            callbacks = new Callback[]{new TextOutputCallback(0, "FileNET Process Engine Authentication"), new NameCallback("user name: "), new PasswordCallback("password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[1]).getName();
                char[] tmpPassword = ((PasswordCallback)callbacks[2]).getPassword();
                password = tmpPassword == null ? new String() : new String(tmpPassword);
                ((PasswordCallback)callbacks[2]).clearPassword();
                this.sharedState.put("javax.security.auth.login.name", this.username);
                this.sharedState.put("javax.security.auth.login.password", password);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
            }
        }
        try {
            String routerurl = System.getProperty("filenet.pe.cm.connectionPoint");
            if (routerurl == null) {
                routerurl = (String)this.options.get("routerurl");
            }
            if (routerurl == null) {
                routerurl = "vwrouter";
            }
            this.session = new VWSession(this.username, password, routerurl);
        }
        catch (VWException vwe) {
            throw new LoginException(vwe.toString());
        }
        this.succeeded = this.session != null;
        logger.exiting("VWLoginModule", "login");
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        logger.entering("VWLoginModule", "commit");
        boolean result = false;
        if (this.succeeded && this.subject != null && this.session != null) {
            try {
                this.principal = new VWPrincipal(this.session.fetchCurrentUserInfo().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.principal != null) {
                if (!this.subject.getPrincipals().contains(this.principal)) {
                    this.subject.getPrincipals().add(this.principal);
                }
                if (!this.subject.getPrivateCredentials().contains(this.session)) {
                    this.subject.getPrivateCredentials().add(this.session);
                }
                this.commitSucceeded = true;
                result = true;
            }
        }
        logger.exiting("VWLoginModule", "commit");
        return result;
    }

    public boolean abort() throws LoginException {
        logger.entering("VWLoginModule", "abort");
        boolean result = false;
        if (!this.succeeded) {
            result = false;
        } else if (!this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.principal = null;
            try {
                this.session.logoff();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session = null;
            result = true;
        } else {
            this.logout();
            result = true;
        }
        logger.exiting("VWLoginModule", "abort");
        return result;
    }

    public boolean logout() throws LoginException {
        logger.entering("VWLoginModule", "logout");
        this.subject.getPrincipals().remove(this.principal);
        this.subject.getPrivateCredentials().remove(this.session);
        this.succeeded = this.commitSucceeded;
        this.username = null;
        this.principal = null;
        try {
            this.session.logoff();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = null;
        logger.exiting("VWLoginModule", "logout");
        return true;
    }

    public static VWSession getSession() throws Exception {
        Subject subject;
        VWSession session = null;
        AccessControlContext acc = AccessController.getContext();
        if (acc != null && (subject = Subject.getSubject(acc)) != null) {
            Iterator<?> iter = null;
            Set<?> creds = subject.getPrivateCredentials(Class.forName("filenet.vw.api.VWSession"));
            if (creds != null) {
                iter = creds.iterator();
            }
            if (iter != null) {
                session = (VWSession)iter.next();
            }
        }
        return session;
    }

    public static VWSession getSession(LoginContext lc) throws Exception {
        Subject subject;
        VWSession session = null;
        if (lc != null && (subject = lc.getSubject()) != null) {
            Iterator<?> iter = null;
            Set<?> creds = subject.getPrivateCredentials(Class.forName("filenet.vw.api.VWSession"));
            if (creds != null) {
                iter = creds.iterator();
            }
            if (iter != null) {
                session = (VWSession)iter.next();
            }
        }
        return session;
    }
}

